﻿#include <iostream>
#include <cmath>
#include <algorithm>
#include <map>
#include <string>
#include <vector>
#include <set>
#include <unordered_map>
#include <unordered_set>
#include <numeric>
#include <stack>
#include <queue>
#include <deque>
#include <fstream>
#include <bitset>

using namespace std;

typedef long long ll;
typedef long double dl;

#define speed_up ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0)
#define endl "\n"

const ll INF = 1e9;

#pragma GCC optimize("Ofast,unroll-loops")
//#pragma GCC target("avx,avx2")

ifstream fin("a.in");
ofstream fout("a.out");

//#define cin fin
//#define cout fout

struct vect {
    ll x, y;

    vect() {
        x = 0, y = 0;
    }

    vect(ll a, ll b) {
        x = a, y = b;
    }

    vect(bool b) {
        cin >> x >> y;
    }
};

ll scal(vect a, vect b) {
    return a.x * b.x + a.y * b.y;
}

ll cross(vect a, vect b) {
    return a.x * b.y - a.y * b.x;
}

struct segment {
    vect v1, v2;
    segment() { }

    segment(vect a, vect b) {
        v1 = a, v2 = b;
    }
};

vect getVec(vect v1, vect v2) {
    return { v2.x - v1.x, v2.y - v1.y };
}

bool operator==(vect v1, vect v2) {
    return v1.x == v2.x && v1.y == v2.y;
}

ll dist2(vect v1, vect v2) {
    ll dx = v1.x - v2.x;
    ll dy = v1.y - v2.y;
    return dx * dx + dy * dy;
}

bool onSegment(vect p, segment s) {
    if (cross(getVec(s.v1, s.v2), getVec(s.v1, p)) == 0) {
        if (dist2(s.v1, p) <= dist2(s.v1, s.v2)) return true;
    }
    return false;
}

bool ronSeg(vect p, segment s) {
    segment res = { s.v2, s.v1 };
    if (onSegment(p, s) && onSegment(p, res)) return true;
    return false;
}

bool isColide(segment s1, segment s2) {
    if (ronSeg(s1.v1, s2) || ronSeg(s1.v2, s2)) return true;
    if (ronSeg(s2.v1, s1) || ronSeg(s2.v2, s1)) return true;
    if (s1.v1 == s2.v1 || s1.v1 == s2.v2 || s1.v2 == s2.v1 || s1.v2 == s2.v2) return true;
    bool a1 = cross(getVec(s1.v1, s1.v2), getVec(s1.v1, s2.v1)) < 0;
    bool a2 = cross(getVec(s1.v1, s1.v2), getVec(s1.v1, s2.v2)) < 0;
    bool a = a1 != a2;

    bool b1 = cross(getVec(s2.v1, s2.v2), getVec(s2.v1, s1.v1)) < 0;
    bool b2 = cross(getVec(s2.v1, s2.v2), getVec(s2.v1, s1.v2)) < 0;
    bool b = b1 != b2;

    return a && b;
}

vector<vector<bool>> used;
vector<vector<ll>> used2;

void fill(ll i, ll n) {
    used[n][i] = true;
    for (auto p : used2[i]) {
        if (!used[n][p] && p != n) fill(p, n);
    }
}

int main() {
    cout << fixed;
    cout.precision(10);
    speed_up;

    ll t; cin >> t;
    while (t--) {
        ll n; cin >> n;
        used2.assign(n, vector<ll>(0));
        used.assign(n, vector<bool>(n));
        vector<segment> vec;
        for (ll i = 0; i < n; i++) {
            vect v1 = true, v2 = true;
            vec.push_back({ v1, v2 });
        }
        //vector<bitset<bssize>> used(n);
        ll ans = 1;
        for (ll i = 0; i < n; i++) {
            for (ll j = 0; j < i; j++) {
                bool b = isColide(vec[i], vec[j]);
                if (!b) continue;
                if (used[i][j]) {
                    ans++;
                }
                else {
                    if (!used[j][i]) {
                        used[j][i] = true;
                        used2[j].push_back(i);
                    }
                    used2[i].push_back(j);
                    used[i][j] = true;
                    fill(j, i);
                }
            }
        }
        cout << ans << endl;
    }
}